﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using System.Data;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail.Helpers;
namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for SalesReport.xaml
    /// </summary>
    public partial class SalesReport : Page
    {
        public SalesReport()
        {
            InitializeComponent();
            txtStartDate.SelectedDate = txtEndDate.SelectedDate = DateTime.Now;
            LoadReport(DateTime.Now, DateTime.Now);
        }
        private void btnExport_Click(object sender, RoutedEventArgs e)
        {
            ExcelExportHelper.Export(gvSalesReport, "SalesReport");
        }
        private void LoadReport(DateTime startDate, DateTime endDate)
        {
            DataTable Sales = ReportsBL.GetSalesReport(startDate, endDate);
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, (bw, we) =>
            {
                //DataTable Sales = ReportsBL.GetSalesReport(startDate, endDate);
                gvSalesReport.Dispatcher.BeginInvoke((Action)(() => gvSalesReport.ItemsSource = Sales.DefaultView));
                
            });

            if (Sales != null && Sales.Rows != null && Sales.Rows.Count > 0)
            {
                try
                {
                    List<object> SalesAmount = Sales.AsEnumerable().Select(a => a.Field<object>("Total")).ToList<object>();
                    SalesAmount.RemoveAll(a => a == null);
                    List<decimal> SalesAmountDecimal = new List<decimal>();
                    SalesAmount.ForEach(a => SalesAmountDecimal.Add((decimal)a));
                    if (SalesAmountDecimal != null)
                    {
                        lblTotalSales.Text = SalesAmountDecimal.Sum().ToString("C");
                    }
                }
                catch (Exception e)
                {
                    MessageBox.Show(e.Message);
                }
            }
        }
        private void btnSearch_Click(object sender, RoutedEventArgs e)
        {
            if (txtStartDate.SelectedDate != null && txtEndDate.SelectedDate != null)
            {
                LoadReport(txtStartDate.SelectedDate.Value, txtEndDate.SelectedDate.Value);
            }
            else
            {
                MessageBox.Show("Please select both the start date and end date", "Error!", MessageBoxButton.OK, MessageBoxImage.Error);
            }
        }
    }
}
